/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_07;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.*;

import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class GetItemReturnValues extends NotesThread{

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH";	//null fr lokale Session
//	private static final PrintStream out = System.out;  //Ausgabe auf System.out
	private static final PrintStream out = fileOut();   //Ausgabe in Datei
	
	/**
	 * Anwendung zur Demonstration des Verhaltens der verschiedenen getItemValue
	 * Methoden bei der Anwendung auf Items unterschiedlicher Datentypen.
	 * @param argv
	 * @throws SAXException
	 */
	public static void main(String[] args) {
		GetItemReturnValues girv = new GetItemReturnValues();
		girv.start();
	}
	public void runNotes() {
		Session session = null;
		Database db = null;
		Document doc = null;

		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase((String) null, "djbuch/djbuch.nsf");
			doc = db.createDocument();
			
			/* *******************************************
			 * Demo 1 - Anzeige leerer Items
			 */
			out.println (LINE + "\nVersuch 1 - Anzeige nicht vorhandener Items" + LINE + "\n");
			showBehaviorGetItem (doc, "gibtsNicht");

			/* *******************************************
			 * Demo 2 - Anzeige von Items unterschiedlichen Datentyps
			 * durch Unterschiedliche Methoden
			 */
			out.println (LINE + "\nVersuch 2 - Anzeige unterschiedlicher Datentypen" + LINE);
			String itemName = "itemInhalt_Ist_";
			insertItems(session, doc,itemName);
			for (int i = 0; i < types.length;i++) {
				out.println ("\nZeige Item <<" + itemName + types[i] + ">>");
				showBehaviorGetItem (doc, itemName + types[i]);				
			}

			/* *******************************************
			 * Demo 3 - Anzeige von Items Vectoren unterschiedlichen Datentyps
			 * durch Unterschiedliche Methoden
			 */
			out.println (LINE + "\nVersuch 3 - Anzeige von Vectoren unterschiedlicher Datentypen" + LINE);
			itemName = "itemInhalt_Ist_Vector_";
			insertItemVector(session, doc,itemName);
			for (int i = 0; i < types.length;i++) {
				out.println ("\nZeige Item <<" + itemName + types[i] + ">>");
				showBehaviorGetItem (doc, itemName + types[i]);				
			}
			
			/* *******************************************
			 * Demo 4 - Mehrere Items gleichen Namens im Dokument
			 */
			out.println (LINE + "\nDemo 4 - Mehrere Items gleichen Namens im Dokument" + LINE);
			doc.recycle(); doc=null;
			doc = db.createDocument();
			itemName = "itemName";
			doc.replaceItemValue(itemName,"Wert 1");
			doc.appendItemValue(itemName, "Wert 2");
			out.println ("Zwei Items, daher nur ein Wert im Vector: " + doc.getItemValue (itemName));
			Item item = doc.getFirstItem(itemName);
			item.remove();
			out.println ("Nach dem Remove des ersten Items: Nun das zweite Item: " + doc.getItemValue (itemName));			
		} catch (NotesException e) {
			e.printStackTrace(System.err);
		} catch (IOException e) {
			e.printStackTrace(System.err);
		} finally {
			try {
				if (doc != null) {doc.recycle();}
				if (db != null) {db.recycle();}
				if (session != null) {session.recycle();} 
			} catch (NotesException e) {
				System.err.println("Fataler Fehler.");
			}
		}
	}

	/**
	 * Versucht im Notes Document doc ein Item mit dem Namen name zu lesen.<br>
	 * Dies wird ber alle getItemValue Methoden versucht:<br>
	 * getItemValueInteger<br>
	 * getItemValueDouble<br>
	 * getItemValueString<br>
	 * getItemValue<br>
	 * getItemValueDateTimeArray<br>
	 * getItemValueCustomData<br>
	 * getItemValueCustomDataBytes<br>
	 * Exceptions werden abgefangen und angezeigt.<br>
	 * @param doc
	 * @param name
	 * @throws NotesException
	 * @throws NotesException
	 * @throws IOException
	 * @throws ClassNotFoundException
	 */
	private static void showBehaviorGetItem(Document doc, String name) throws NotesException{
		out.println ("hasItem(\"" + name + "\"):\t\t\t\t" + doc.hasItem(name));
		try {
			out.print ("getItemValueInteger(\"" + name + "\"):\t\t");
			out.println (doc.getItemValueInteger (name));					
		} catch (Exception e) {
			out.println("Exception " + e.toString());			
		}
		try {
			out.print ("getItemValueDouble(\"" + name + "\"):\t\t");
			out.println (doc.getItemValueDouble (name));					
		} catch (Exception e) {
			out.println("Exception " + e.toString());			
		}
		try {
			out.print ("getItemValueString(\"" + name + "\"):\t\t");
			out.println (doc.getItemValueString (name));					
		} catch (Exception e) {
			out.println("Exception " + e.toString());			
		}
		try {
			out.print ("getItemValue(\"" + name + "\"):\t\t\t");
			out.println (doc.getItemValue (name));					
		} catch (Exception e) {
			out.println("Exception " + e.toString());			
		}
		try {
			out.print ("getItemValueDateTimeArray(\"" + name + "\"):\t");
			out.println (doc.getItemValueDateTimeArray (name) + " (" + doc.getItemValueDateTimeArray (name).getClass().getName() + ")");
		} catch (NotesException e) {
			out.println("Kein DateTimeItem - " + e.toString() + " (" + e.id + ")");
		}
		try {
			out.print ("getItemValueCustomData(\"" + name + "\"):\t\t");
			out.println ((doc.getItemValueCustomData (name, TYPE_NAME)).toString());
		} catch (NullPointerException e) {
			out.println("Fehlendes Custom Item - " + e.toString());			
		} catch (Exception e) {
			out.println("Exception " + e.toString());						
		}
		try {
			out.print ("getItemValueCustomDataBytes(\"" + name + "\"):\t");
			out.println (byteToString (doc.getItemValueCustomDataBytes (name, TYPE_NAME)));
		} catch (NullPointerException e) {
			out.println("Fehlendes Custom Item Bytes - " + e.toString());						
		} catch (Exception e) {
			out.println("Exception " + e.toString());						
		}
		try {
			Item item = doc.getFirstItem(name);
			out.print ("getFirstItem (\"" + name + "\").getText():\t");
			try {
				out.print (item.getText());
			} catch (NotesException e) {
				out.print (" NotesException bei getFirstItem oder getText :" + e.getMessage());
			}
			out.println (" (Size = " + item.getValueLength() + ")");
		} catch (Exception e) {
			out.println("Exception " + e.toString());						
		}
	}
	
	/**
	 * Hilfsmethode zur Umwandlung eines ByteArrays in einen String
	 * @param bArr
	 * @return
	 */
	private static String byteToString(byte[] bArr) {
		if (bArr == null || bArr.length==0) {
			return null;
		}
		StringBuffer buf = new StringBuffer ();
		for (int i = 0; i<bArr.length;i++) {
			buf.append((char)bArr [i]);
		}
		return buf.toString();
	}

	/**
	 * Erzeugt im Document doc je ein Item mit Namen name+<<i>> (i = 0..5)<br>
	 * jeweils mit den Datentypen Integer, Double, String, DateTime, Custom,<br>
	 * Custom (als ByteArray)
	 * @param session
	 * @param doc
	 * @param name
	 * @throws NotesException
	 * @throws IOException
	 */
	private static void insertItems (Session session, Document doc, String name) throws NotesException, IOException {
		doc.replaceItemValue(name+types[0], new Integer (1));
		doc.replaceItemValue(name+types[1], new Double (1.7));
		doc.replaceItemValue(name+types[2], "mein String");
		DateTime dt = session.createDateTime ("Yesterday 11:35:07");
		doc.replaceItemValue(name+types[3], dt);
		CustomClass custom = new CustomClass("Vorname Nachname", Calendar
				.getInstance().getTime());
		doc.replaceItemValueCustomData (name+types[4], TYPE_NAME, custom);
		doc.replaceItemValueCustomDataBytes (name+types[5], TYPE_NAME, custom.toString().getBytes());
	}
	
	/**
	 * Erzeugt im Document doc je ein Item mit Namen name+<<i>> (i = 0..5)<br>
	 * jeweils mit Vectoren der Datentypen Integer, Double, String, DateTime, Custom,<br>
	 * Custom (als ByteArray)
	 * @see insertitems (Session, Document, String)
	 * @param session
	 * @param doc
	 * @param name
	 * @throws NotesException
	 * @throws IOException
	 */
	private static void insertItemVector (Session session, Document doc, String name) throws NotesException, IOException {
		Vector v = new Vector();
		v.add(new Integer (3));
		v.add(new Integer (4));
		doc.replaceItemValue(name+types[0], v);
		v = new Vector();
		v.add(new Double (2.2));
		v.add(new Double (2.3));
		doc.replaceItemValue(name+types[1], v);
		v = new Vector();
		v.add("Wert a");
		v.add("Wert b");		
		doc.replaceItemValue(name+types[2], v);
		Item item = doc.getFirstItem (name+types[2]);
		item.appendToTextList("Wert c via append");
		v = new Vector();
		DateTime dt = session.createDateTime ("Yesterday 11:35:07");
		v.add(dt);
		dt = session.createDateTime("Today");
		v.add(dt);
		dt = session.createDateTime("17.07.2007");
		v.add(dt);
		doc.replaceItemValue(name+types[3], v);		
		v = new Vector();
		CustomClass custom = new CustomClass("Vorname1 Nachname1", Calendar
				.getInstance().getTime());
		v.add (custom);
		custom = new CustomClass("Vorname2 Nachname2", Calendar
				.getInstance().getTime());		
		doc.replaceItemValueCustomData (name+types[4], TYPE_NAME, v);
		//replaceItemValueCustomDataBytes macht hier keinen Sinn.
	}
	
	private static final PrintStream fileOut (){
		PrintStream result = null;
		String basePath = System.getProperty("user.dir")
				+ "/src/djbuch/kapitel_06/";
		File file = new File(basePath + "debug");
		if (!file.exists()) {
			file.mkdirs();
		}
		FileOutputStream fileOut;
		try {
			fileOut = new FileOutputStream(basePath
					+ "debug/output.txt", true);
			result = new PrintStream(fileOut);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			result = System.out;
		}
		return result;
	}
	
	private static final String TYPE_NAME = "FreiGewaehlterTypName";
	private static final String [] types = {"Integer", "Double", "String", "Date", "Custom", "CustomBytes"};
	private static final String LINE = "\n************************************************************";

}
